/*---------------------------------------------------------------------------*\

    FILE....: PLAYREC.H
    TYPE....: C++ Module
    AUTHOR..: David Rowe
    DATE....: 10/2/98

    This module implements the play and record functions for the VPB API,
    which are shamelessly modelled along the lines of the equivilent 
    Dialogic functions.
	 
\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef	__PLAYREC__
#define	__PLAYREC__

#include "contypes.h"
#include "apifunc.h"

void playrec_open(USHORT numch);
void playrec_close();

// "internal" versions of API functions

void play_file(int handle, char file_name[], USHORT mode, int file_type, 
	       int sync, int data);
void play_buf_finish(int handle);
int  play_buf_sync(int handle, char *buf, unsigned short length);
void play_buf_start(int handle, unsigned short mode);

void record_file(int handle, char file_name[], USHORT mode, int file_type, 
		 int sync, int data);
void record_buf_finish(int handle);
int  record_buf_sync(int handle, char *buf, unsigned short length);
void record_buf_start(int handle, unsigned short mode);

// terminate on digit functions

void playrec_new_digit_record(int h, USHORT digit);
void playrec_new_digit_play(int h, USHORT digit);

// diagnostic helper

int playrec_underflow_valid(int handle);

// callback from MMQ

void playrec_fifo_disabled(int h);

#endif	// __PLAYREC__
